//
//  FindUSBDevice.h
//  DriveUnlock
//
//  Created by Bob on 3/9/09.
//  Copyright © 2014 Western Digital Technologies, Inc. All rights reserved.
//

#import "WDDevices.h"
#import "WDDevice.h"
#import <IOKit/usb/IOUSBLib.h>


@interface WDDevices (FindUSBDevices)

- (id) registerNotificationsForUSBPIDS: (NSArray *)supportedPids;

void USBDeviceAddedCallback(void* refCon, io_iterator_t iter);
void USBDeviceRemovedCallback(void* refCon, io_iterator_t iter);
void mediaAppearedCallback(void* refCon, io_iterator_t iterator);
void mediaDisappearedCallback(void* refCon, io_iterator_t iterator);

- (void) USBDeviceAdded: (io_iterator_t) iterator;
- (void) USBDeviceRemoved: (io_iterator_t) iterator;
- (void) currentDevices;
- (void) currentVolumes;
- (void) currentDevicesForStatus;
- (WDDevice *) findWDDeviceForPath: (NSString *) path;
- (WDDevice *) findWDDeviceForMountPath: (NSString *) path;
- (void) mediaAppeared: (io_iterator_t)service;


@end
